/* ...............................................................

	WindowColors
	Copyright 1997-8 Steve Klingsporn <moofie@pobox.com>
	Based on WindowShade by Marco Nelissen <marcone@xs4all.nl>
	
		File:	ColorPicker.h
	
	Contains:	Class definition and includes for color picker
				BColorControl subclass.
	
	   Notes:	None.
	   
   ............................................................... */

#ifndef _COLOR_PICKER_H
#define _COLOR_PICKER_H

#ifndef _COLOR_CONTROL_H
#include <ColorControl.h>
#endif

#ifndef _WINDOW_COLORS_H
#include "WindowColors.h"
#endif

#ifndef _WINDOW_COLORS_APPLICATION_H
#include "WindowColorsApplication.h"
#endif

#ifndef _COLOR_LABEL_H
#include "ColorLabel.h"
#endif


/* ...............................................................
	ColorPicker class
   ............................................................... */

class ColorPicker : public BColorControl
{
	public:
						ColorPicker(BPoint start);
						
		void			MouseDown(BPoint where);
		void			AttachedToWindow();
		void			SetValue(int32 value);
		void			SetValue(rgb_color color);
		void			SetValueQuietly(rgb_color color);
};


/* ...............................................................
	ColorPicker::SetValue()
	Copied from <ColorControl.h> so this method isn't hidden here.
   ............................................................... */

inline void ColorPicker::SetValue(rgb_color color)
{
	int32 c = (color.red << 24) + (color.green << 16) + 
			  (color.blue << 8);
	SetValue(c);
}

#endif